<title>{{ Auth::user()->name }} - bestleearning</title>
@extends('user.layouts.master')
@section('css')
 <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/argon.css" type="text/css">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/myapp.css" type="text/css">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/bttn.css" type="text/css">
    <style>
    
    .directory-card {
        background-color: #f8f9fa;
        border: 1px solid #e3e6f0;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        border-radius: 10px;
        padding: 20px;
    }

    .directory-card .card-body {
        padding: 30px;
    }

    .avatar-lg {
        width: 120px;
        height: 120px;
    }

    .badge {
        font-size: 12px;
    }


    .font-weight-bold {
        font-weight: 700;
    }

    .text-muted {
        color: #6c757d !important;
    }

    .btn-sm {
        font-size: 13px;
    }
    
    
    @media only screen and (min-width: 768px) {
    .card {
        margin-top: 15px !important;
        margin-bottom: 15px !important;
        margin-right: 9px !important;
           margin-left: 9px !important;
    }
}

    
    
        .bg-gradient-green {
            background: linear-gradient(87deg,#2dce89 0,#2dcecc 100%)!important;
        }
        .bg-gradient-info {
            background: linear-gradient(87deg,#11cdef 0,#1171ef 100%)!important;
        }
        .icon-shape {
            display: inline-flex;
            /* padding: 12px; */
            text-align: center;
            border-radius: 50%;
            align-items: center;
            justify-content: center;
        }
        .icon {
            width: 3rem;
            height: 3rem;
        }
        .icon-shape i, .icon-shape svg {
            font-size: 1.25rem;
        }
    </style>
@endsection
@section('user-content')

<div class="row mt-2">
	<div class="col-xl-4 order-xl-2">
		<div class="card card-profile">
			<img src="https://blogger.googleusercontent.com/img/b/R29vZ2xl/AVvXsEg_X-37RyKqeo8TQbH8JHUZTe8w8A9v94aZCg__atVZuqQGJHnbMBQC7s9HaGL2n5j_yLU45lxU1czufoNpTbZyTpCsBGuStkGq2DtC1UWGxn11TgZIrwIcDM2t_NTM4WX4HFYjgCK-JU5KF9o_oPh4nXFMJegYV2RHv35o0wx-uyutL5soIbrpofvB1-0/s320-rw/photo_2025-02-25_17-30-20.png" alt="Image placeholder" class="card-img-top">
			<div class="row justify-content-center">
				<div class="col-lg-3 order-lg-2">
					<div class="card-profile-image">
						<a href="#">
							@if(file_exists(Auth::user()->image))
                                <img alt="" class="rounded-circle" src="{{ URL::to(Auth::user()->image) }}" width="120px" height="120px">
                            @else
                                <img class="rounded-circle" src="{{ asset('frontend/img/user.png') }}" alt="User Image" width="120px" height="120px">
                            @endif
						</a>
					</div>
				</div>
			</div>
			<div class="card-header text-center border-0 pt-5 pt-md-4 pb-0 pb-md-4"></div>
			<div class="card-body">
				<div class="text-center">
					<h5 class="h2">
						{{ Auth::user()->name }}
						@if(Auth::user()->premium_status == 0)
                            <a class="btn btn-sm" style="background-color: transparent; border: 1px solid red; color: red; font-weight: bold; font-size: 6px;">
                                <i class="fas fa-times-circle"></i> Not Verified
                            </a>
                        @else
                            <i class="fas fa-check-circle"></i>
                        @endif 

					</h5>
					<p class="drk-bg-one"><span style='background: #eaeaea;border-radius:5px;padding:2px 5px 2px 5px'>{{ user_work_rating(Auth::user()->id) }} Reviews ({{ user_rating(Auth::user()->id) }}) @if(user_rating(Auth::user()->id) >= 2.5)<i class="fa fa-star checked" style="color:#F37205"></i>@endif</span></p>
					@if(session('user_age'))
					<p class="text-muted">I&#039;m {{ session('user_age') }} years old</p>
					@endif
					<p class="text-muted">Since {{ \Carbon\Carbon::parse(Auth::user()->created_at)->format('j M, y')}}</p>
					@if(user_activity(Auth::user()->id) == 1)
					<small class="text-muted"><span style='color:#239B56;'> I'm online </span></small>
					@else
					<small class="text-muted"><span style='color:#a2240b;'> I'm offline </span></small>
					@endif
					<div class="h5 font-weight-300">
						<h4>User ID: {{ Auth::user()->code }}</h4>	<span class='text'><i class='fas fa-globe'></i> {{ country(Auth::user()->country) }}</span> <span class='text'> - {{ session('user_bio') }}{{ Auth::user()->phone }}</span>
					</div>
					Default
				
					
					 <br>
					<a class="btn btn-primary mt-2 btn-sm bttn" style="border-radius:20px" href="{{ route('user.manage-profile') }}">Manage Profile</a>
				</div>
			</div>
		</div>
		
		@if ((site_info()->instanat_verify_active == 1 || site_info()->need_user_verification == 1) && Auth::user()->is_verified == 0)
            <div class="">
                <a href="{{ route('user.account-instant-verify') }}">
                    <div class="card bg-gradient-red">
                        <div class="card-body">
                            <h3 class="card-title text-white">Account Not Verified!</h3>
                            <p class="text-white mb-0">Please verify your account for work.</p>
                        </div>
                    </div>
                </a>
            </div>
        @endif

@php
    $approve_ratio = work_approve_ratio(Auth::user()->id);
    $pending_ratio = work_pending_ratio(Auth::user()->id);
    $total_percentage = $approve_ratio + $pending_ratio;
    $total_percentage = min($total_percentage, 100); 
    $work_sutisfied = number_format($total_percentage, 0) . '%';
    $job_sutisfied = number_format(job_approve_ratio(Auth::user()->id), 0) . '%';
@endphp
		
		<div class="card bg-gradient-green border-0">
			<!-- Card body -->
			<div class="card-body">
				<div class="row">
					<div class="col">
						<h5 class="card-title text-uppercase text-muted mb-0 text-white">WORK RATED</h5>
						<span class="h2 font-weight-bold mb-0 text-white">{{ total_attend_work(Auth::user()->id) }}</span>
					</div>
					<div class="col-auto">
						<div class="icon icon-shape bg-white text-dark rounded-circle shadow">
							<i class="fas fa-tasks"></i>
						</div>
					</div>
				</div>
				<p class="mt-3 mb-0 text-sm">
					<span class="text-white mr-2 font-weight-500"><i class="fa fa-percentage"></i> {{$work_sutisfied}}</span>
					<span class="text-nowrap text-light font-weight-500">Satisfaction</span>
				</p>
			</div>
		</div>
	    @if (total_attend_work(Auth::user()->id) >= 40)
             <div class="alert text-center" id="satisfaction-warning" style="color: red; font-weight: 500; @if ($work_sutisfied >= 75) display: none; @endif">
            </div>
        @endif
       
		<div class="card bg-gradient-info border-0">
			<!-- Card body -->
			<div class="card-body">
				<div class="row">
					<div class="col">
						<h5 class="card-title text-uppercase text-muted mb-0 text-white">JOB</h5>
						<span class="h2 font-weight-bold mb-0 text-white">{{ user_total_job(Auth::user()->id) }}</span>
					</div>
					<div class="col-auto">
						<div class="icon icon-shape bg-white text-dark rounded-circle shadow">
							<i class="fas fa-briefcase"></i>
						</div>
					</div>
				</div>
				<p class="mt-3 mb-0 text-sm">
					<span class="text-white mr-2 font-weight-500"><i class="fa fa-percentage"></i> {{ total_ratio_by_user(Auth::user()->id) }}%</span>
					<span class="text-nowrap text-light font-weight-500">Satisfied</span>
				</p>
			</div>
		</div>

	</div>
	<div class="col-xl-8 order-xl-1">

		<div class="row justify-content-center">
			<div class="col-12">

				<div class="card">
					<div class="card-header">
						<h6 class="surtitle">Overview</h6>
						<h5 class="h3 mb-0">Total Working</h5>
					</div>
					<div class="card-body cust_task_working">
						<div class="row mb-2">
							<div class="col-6">Task Attend</div>
							<div class="col-6 text-primary h2">{{ total_attend_work(Auth::user()->id) }}</div>
						</div>
						<div class="row mb-2">
							<div class="col-6">Earned</div>
							<div class="col-6">$0</div>
						</div>
						<div class="row mb-2">
							<div class="col-6">Satisfied <br> <h6>Approved in task</h6></div>
							
							<div class="col-6 text-success h2">{{ user_complete_job_approve(Auth::user()->id) }}</div>
						</div>
						<div class="row mb-2">
							<div class="col-6">Not Satisfied<br><h6>Rejected in task prove</h6></div>
							<div class="col-6 text-danger h2">{{ user_complete_job_reject(Auth::user()->id) }}</div>
						</div>
						<div class="row mb-2">
							<div class="col-6">Pending <br><h6>In review for rating</h6></div>
							<div class="col-6 text-info h2">{{ user_complete_job_pending(Auth::user()->id) }}</div>
						</div>
						<div class="row mb-2">
							<div class="col-6">Deleted/Removed task <br> <h6></h6></div>
							<div class="col-6 text-danger h2">0</div>
						</div>
												<div class="row mb-2">
							<div class="col-6">Payment Received</div>
							<div class="col-6 h3" style="color:#ffad29">${{ number_format(count_total_withdraws(Auth::user()->id), 2) }}</div>
						</div>
												<div class="row mb-2">
							<div class="col-6">Last Task</div>
							<div class="col-6 text-info h3">@if(last_worked_job(Auth::user()->id)) {{ \Carbon\Carbon::parse(last_worked_job(Auth::user()->id)->created_at)->format('j M, y') }} @endif</div>
						</div>
						
						
					</div>
				</div>

				<div class="card">
					<div class="card-header">
						<h6 class="surtitle">Overview</h6>
						<h5 class="h3 mb-0">Total Job</h5>
					</div>
					<div style="color:#27954f">
						<div class="card-body">
							<div class="row mb-2">
								<div class="col-6">Valid Jobs Posted</div>
								<div class="col-6">{{ user_total_job(Auth::user()->id) }}</div>
							</div>
							<div class="row mb-2">
								<div class="col-6">Total Deposit</div>
								<div class="col-6">${{ number_format(count_total_deposits(Auth::user()->id), 2) }}</div>
							</div>
							<div class="row mb-2">
								<div class="col-6">Paid</div>
								<div class="col-6">${{ number_format(total_balance_spend(Auth::user()->id), 2) }}</div>
							</div>
							<div class="row mb-2 text-red">
								<div class="col-6">Job Over</div>
								<div class="col-6">{{ count_jobs_over(Auth::user()->id) }}</div>
							</div>
						</div>
					</div>
				</div>
								
			</div>

		</div>
	</div>
</div>


		
            
    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="text-center">Working Status</h4>
                    <div class="d-flex justify-content-center">
                        <canvas id="working_status" style="width="320" height="320"></canvas>
                    </div>
                </div>
            </div>
        </div>
    
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="text-center">Job Status</h4>
                    <div class="d-flex justify-content-center">
                        <canvas id="job_status" style="width="320" height="320"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

   
@php
    $work_sutisfied = work_approve_ratio(Auth::user()->id);
    $work_pending = work_pending_ratio(Auth::user()->id);
    $work_reject = work_reject_ratio(Auth::user()->id);
    
    $job_sutisfied = job_approve_ratio(Auth::user()->id);
    $job_pending = job_pending_ratio(Auth::user()->id);
    $job_reject = job_reject_ratio(Auth::user()->id);
@endphp

</section>

@endsection
@section('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.js"></script>
    
    <script>
    var xValues = ["Satisfied", "Unsatisfied", "Pending", "Not Rated"];
    var workValues = [{{$work_sutisfied}}, {{$work_reject}}, {{$work_pending}}];
    var jobValues = [{{$job_sutisfied}}, {{$job_reject}}, {{$job_pending}}];
    var barColors = [
        "#00aba9",
        "#b91d47",
        "#f5c242",
        "#BDC3C7"
    ];

    // Calculate the NotRated value dynamically
    var workNotRated = 100 - (workValues.reduce((acc, val) => acc + val, 0));
    var jobNotRated = 100 - (jobValues.reduce((acc, val) => acc + val, 0));

    workValues.push(workNotRated);
    jobValues.push(jobNotRated);

    new Chart("working_status", {
        type: "doughnut",
        data: {
            labels: xValues,
            datasets: [{
                backgroundColor: barColors,
                data: workValues
            }]
        },
        options: {
            title: {
                display: true
            }
        }
    });

    new Chart("job_status", {
        type: "doughnut",
        data: {
            labels: xValues,
            datasets: [{
                backgroundColor: barColors,
                data: jobValues
            }]
        },
        options: {
            title: {
                display: true
            }
        }
    });
</script>
@endsection
